#ifndef __SERCOSIII_MA_AP_ERROR_H
#define __SERCOSIII_MA_AP_ERROR_H




/////////////////////////////////////////////////////////////////////////////////////
// Sercos III - Result and Status Codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_SIII_MA_AP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command value.
//
#define TLR_E_SIII_MA_AP_COMMAND_INVALID ((TLR_RESULT)0xC0720001L)

//
// MessageId: TLR_E_SIII_MA_AP_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup parameter.
//
#define TLR_E_SIII_MA_AP_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0720002L)

//
// MessageId: TLR_E_SIII_MA_AP_MDT_PROCESS_DATA_IMAGE_SIZE_NOT_POSSIBLE
//
// MessageText:
//
//  Output Process Data Image Size not possible (MDT).
//
#define TLR_E_SIII_MA_AP_MDT_PROCESS_DATA_IMAGE_SIZE_NOT_POSSIBLE ((TLR_RESULT)0xC0720003L)

//
// MessageId: TLR_E_SIII_MA_AP_AT_PROCESS_DATA_IMAGE_SIZE_NOT_POSSIBLE
//
// MessageText:
//
//  Input Process Data Image Size not possible (AT).
//
#define TLR_E_SIII_MA_AP_AT_PROCESS_DATA_IMAGE_SIZE_NOT_POSSIBLE ((TLR_RESULT)0xC0720004L)

//
// MessageId: TLR_E_SIII_MA_AP_LLD_NOT_STARTED
//
// MessageText:
//
//  SercosIII Low Level Driver not started.
//
#define TLR_E_SIII_MA_AP_LLD_NOT_STARTED ((TLR_RESULT)0xC0720005L)

//
// MessageId: TLR_E_SIII_MA_AP_SET_PHASE_NOT_ALLOWED_DURING_CFG_LOADING
//
// MessageText:
//
//  Set Phase command not allowed during configuration loading.
//
#define TLR_E_SIII_MA_AP_SET_PHASE_NOT_ALLOWED_DURING_CFG_LOADING ((TLR_RESULT)0xC0720006L)

//
// MessageId: TLR_E_SIII_MA_AP_PACKET_CFG_INTERFACE_NOT_AVAILABLE_DURING_CFG_LOADING
//
// MessageText:
//
//  Configuration via packets is not available during configuration loading.
//
#define TLR_E_SIII_MA_AP_PACKET_CFG_INTERFACE_NOT_AVAILABLE_DURING_CFG_LOADING ((TLR_RESULT)0xC0720007L)

//
// MessageId: TLR_E_SIII_MA_AP_C1D_DIAGNOSIS_ERROR
//
// MessageText:
//
//  C1D Diagnosis Error.
//
#define TLR_E_SIII_MA_AP_C1D_DIAGNOSIS_ERROR ((TLR_RESULT)0xC0720008L)

//
// MessageId: TLR_E_SIII_MA_AP_BUS_SYNC_ERROR_THRESHOLD
//
// MessageText:
//
//  Bus Sync Error Threshold reached.
//
#define TLR_E_SIII_MA_AP_BUS_SYNC_ERROR_THRESHOLD ((TLR_RESULT)0xC0720009L)

//
// MessageId: TLR_E_SIII_MA_AP_CHANNEL_INIT
//
// MessageText:
//
//  Channel-Init detected.
//
#define TLR_E_SIII_MA_AP_CHANNEL_INIT    ((TLR_RESULT)0xC072000AL)

//
// MessageId: TLR_E_SIII_MA_AP_CPX_CP0_DEV_STATUS_INVALID_TIMEOUT
//
// MessageText:
//
//  CPx -> CP0 Dev Status Invalid Timeout.
//
#define TLR_E_SIII_MA_AP_CPX_CP0_DEV_STATUS_INVALID_TIMEOUT ((TLR_RESULT)0xC072000BL)

//
// MessageId: TLR_E_SIII_MA_AP_CP1_CP2_DEV_STATUS_INVALID_TIMEOUT
//
// MessageText:
//
//  CP1 -> CP2 Dev Status Invalid Timeout.
//
#define TLR_E_SIII_MA_AP_CP1_CP2_DEV_STATUS_INVALID_TIMEOUT ((TLR_RESULT)0xC072000CL)

//
// MessageId: TLR_E_SIII_MA_AP_CP2_CP3_DEV_STATUS_INVALID_TIMEOUT
//
// MessageText:
//
//  CP2 -> CP3 Dev Status Invalid Timeout.
//
#define TLR_E_SIII_MA_AP_CP2_CP3_DEV_STATUS_INVALID_TIMEOUT ((TLR_RESULT)0xC072000DL)

//
// MessageId: TLR_E_SIII_MA_AP_CP3_CP4_DEV_STATUS_INVALID_TIMEOUT
//
// MessageText:
//
//  CP3 -> CP4 Dev Status Invalid Timeout.
//
#define TLR_E_SIII_MA_AP_CP3_CP4_DEV_STATUS_INVALID_TIMEOUT ((TLR_RESULT)0xC072000EL)

//
// MessageId: TLR_E_SIII_MA_AP_CP1_DEV_STATUS_VALID_TIMEOUT
//
// MessageText:
//
//  CP1 Dev Status Valid Timeout.
//
#define TLR_E_SIII_MA_AP_CP1_DEV_STATUS_VALID_TIMEOUT ((TLR_RESULT)0xC072000FL)

//
// MessageId: TLR_E_SIII_MA_AP_CP2_DEV_STATUS_VALID_TIMEOUT
//
// MessageText:
//
//  CP2 Dev Status Valid Timeout.
//
#define TLR_E_SIII_MA_AP_CP2_DEV_STATUS_VALID_TIMEOUT ((TLR_RESULT)0xC0720010L)

//
// MessageId: TLR_E_SIII_MA_AP_CP3_DEV_STATUS_VALID_TIMEOUT
//
// MessageText:
//
//  CP3 Dev Status Valid Timeout.
//
#define TLR_E_SIII_MA_AP_CP3_DEV_STATUS_VALID_TIMEOUT ((TLR_RESULT)0xC0720011L)

//
// MessageId: TLR_E_SIII_MA_AP_CP4_DEV_STATUS_VALID_TIMEOUT
//
// MessageText:
//
//  CP4 Dev Status Valid Timeout.
//
#define TLR_E_SIII_MA_AP_CP4_DEV_STATUS_VALID_TIMEOUT ((TLR_RESULT)0xC0720012L)

//
// MessageId: TLR_E_SIII_MA_AP_CP3_TIMING_CONFIGURATION_ERROR
//
// MessageText:
//
//  CP3 Timing Configuration Error.
//
#define TLR_E_SIII_MA_AP_CP3_TIMING_CONFIGURATION_ERROR ((TLR_RESULT)0xC0720013L)

//
// MessageId: TLR_E_SIII_MA_AP_CP0_CP1_TOPO_ADDR_INVALID_TIMEOUT
//
// MessageText:
//
//  CP0 -> CP1 Topology Address Invalid Timeout.
//
#define TLR_E_SIII_MA_AP_CP0_CP1_TOPO_ADDR_INVALID_TIMEOUT ((TLR_RESULT)0xC0720014L)

//
// MessageId: TLR_E_SIII_MA_AP_UNKNOWN_STATE_CHG_STOPPED_REASON
//
// MessageText:
//
//  Unknown State Change Stopped Reason.
//
#define TLR_E_SIII_MA_AP_UNKNOWN_STATE_CHG_STOPPED_REASON ((TLR_RESULT)0xC0720015L)

//
// MessageId: TLR_E_SIII_MA_AP_INITCMD_ERROR
//
// MessageText:
//
//  Service channel access failed (InitCmd).
//
#define TLR_E_SIII_MA_AP_INITCMD_ERROR   ((TLR_RESULT)0xC0720016L)

//
// MessageId: TLR_E_SIII_MA_AP_CONN_LENGTH_ERROR
//
// MessageText:
//
//  Connection Length mismatch.
//
#define TLR_E_SIII_MA_AP_CONN_LENGTH_ERROR ((TLR_RESULT)0xC0720017L)

//
// MessageId: TLR_E_SIII_MA_AP_S_0_127_COMMAND_ERROR
//
// MessageText:
//
//  S-0-127 Command execution ended with error.
//
#define TLR_E_SIII_MA_AP_S_0_127_COMMAND_ERROR ((TLR_RESULT)0xC0720018L)

//
// MessageId: TLR_E_SIII_MA_AP_S_0_128_COMMAND_ERROR
//
// MessageText:
//
//  S-0-128 Command execution ended with error.
//
#define TLR_E_SIII_MA_AP_S_0_128_COMMAND_ERROR ((TLR_RESULT)0xC0720019L)

//
// MessageId: TLR_E_SIII_MA_AP_S_0_1024_COMMAND_ERROR
//
// MessageText:
//
//  S-0-1024 Command execution ended with error.
//
#define TLR_E_SIII_MA_AP_S_0_1024_COMMAND_ERROR ((TLR_RESULT)0xC072001AL)

//
// MessageId: TLR_E_SIII_MA_AP_MDT_NOT_EXCHANGED
//
// MessageText:
//
//  MDT not exchanged.
//
#define TLR_E_SIII_MA_AP_MDT_NOT_EXCHANGED ((TLR_RESULT)0xC072001BL)

//
// MessageId: TLR_E_SIII_MA_AP_AT_NOT_EXCHANGED
//
// MessageText:
//
//  AT not exchanged.
//
#define TLR_E_SIII_MA_AP_AT_NOT_EXCHANGED ((TLR_RESULT)0xC072001CL)

//
// MessageId: TLR_E_SIII_MA_AP_FRAME_LOSS
//
// MessageText:
//
//  Frame loss.
//
#define TLR_E_SIII_MA_AP_FRAME_LOSS      ((TLR_RESULT)0xC072001DL)

//
// MessageId: TLR_E_SIII_MA_AP_EXT_TRIGGER_TIMEOUT
//
// MessageText:
//
//  No signal on External Trigger input within timeout.
//
#define TLR_E_SIII_MA_AP_EXT_TRIGGER_TIMEOUT ((TLR_RESULT)0xC072001EL)

//
// MessageId: TLR_E_SIII_MA_AP_EXT_TRIGGER_LOSS
//
// MessageText:
//
//  Signal lost on External Trigger input.
//
#define TLR_E_SIII_MA_AP_EXT_TRIGGER_LOSS ((TLR_RESULT)0xC072001FL)

//
// MessageId: TLR_E_SIII_MA_AP_ALL_SLAVES_LOST
//
// MessageText:
//
//  All slaves lost.
//
#define TLR_E_SIII_MA_AP_ALL_SLAVES_LOST ((TLR_RESULT)0xC0720020L)

//
// MessageId: TLR_E_SIII_MA_AP_BUS_SCAN_TIMEOUT
//
// MessageText:
//
//  Bus Scan Timeout.
//
#define TLR_E_SIII_MA_AP_BUS_SCAN_TIMEOUT ((TLR_RESULT)0xC0720021L)

//
// MessageId: TLR_E_SIII_MA_AP_INTERNAL_ERROR
//
// MessageText:
//
//  Internal Error detected.
//
#define TLR_E_SIII_MA_AP_INTERNAL_ERROR  ((TLR_RESULT)0xC0720022L)

//
// MessageId: TLR_E_SIII_MA_AP_S_0_1050_X_5_CONN_LENGTH_READ_ERROR
//
// MessageText:
//
//  Connection Length could not be read due to incorrect configuration.
//
#define TLR_E_SIII_MA_AP_S_0_1050_X_5_CONN_LENGTH_READ_ERROR ((TLR_RESULT)0xC0720023L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_OPENING_TAG
//
// MessageText:
//
//  XML structure: Closing Tag does not match opening tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_OPENING_TAG ((TLR_RESULT)0xC0724000L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_NUMBER_FIELD
//
// MessageText:
//
//  XML structure: Unexpected opening tag in number field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_NUMBER_FIELD ((TLR_RESULT)0xC0724001L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_NUMBER_FIELD
//
// MessageText:
//
//  XML structure: Unexpected single tag in number field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_NUMBER_FIELD ((TLR_RESULT)0xC0724002L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_NUMBER_FIELD_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match number field tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_NUMBER_FIELD_TAG ((TLR_RESULT)0xC0724003L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_NUMBER_FIELD_IS_INVALID
//
// MessageText:
//
//  XML structure: Number Field is invalid.
//
#define TLR_E_SIII_MA_AP_XML_NUMBER_FIELD_IS_INVALID ((TLR_RESULT)0xC0724004L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_STRING_FIELD
//
// MessageText:
//
//  XML structure: Unexpected opening tag in string field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_STRING_FIELD ((TLR_RESULT)0xC0724005L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STRING_FIELD
//
// MessageText:
//
//  XML structure: Unexpected single tag in string field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STRING_FIELD ((TLR_RESULT)0xC0724006L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STRING_FIELD_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match string field tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STRING_FIELD_TAG ((TLR_RESULT)0xC0724007L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_DATA_FIELD
//
// MessageText:
//
//  XML structure: Unexpected opening tag in data field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_DATA_FIELD ((TLR_RESULT)0xC0724008L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_DATA_FIELD
//
// MessageText:
//
//  XML structure: Unexpected single tag in data field.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_DATA_FIELD ((TLR_RESULT)0xC0724009L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_DATA_FIELD_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match data field tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_DATA_FIELD_TAG ((TLR_RESULT)0xC072400AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DATA_FIELD_IS_NOT_A_HEX_STRING
//
// MessageText:
//
//  XML structure: Data field is not a hex string.
//
#define TLR_E_SIII_MA_AP_XML_DATA_FIELD_IS_NOT_A_HEX_STRING ((TLR_RESULT)0xC072400BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SIIICFG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in SIIICfg block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SIIICFG_BLOCK ((TLR_RESULT)0xC072400CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SIIICFG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected tag in SIIICfg block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SIIICFG_BLOCK ((TLR_RESULT)0xC072400DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_CLOSING_TAG_IN_SIIICFG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected closing tag in SIIICfg block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_CLOSING_TAG_IN_SIIICFG_BLOCK ((TLR_RESULT)0xC072400EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_TAG_IN_SIIICFG_BLOCK_SLAVE_PART
//
// MessageText:
//
//  XML structure: Unexpected closing tag in SIIICfg block (Slave Part).
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_TAG_IN_SIIICFG_BLOCK_SLAVE_PART ((TLR_RESULT)0xC072400FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SIIICFG_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match SIIICfg tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SIIICFG_TAG ((TLR_RESULT)0xC0724010L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_FILE_IS_NOT_A_SIIICFG_XML
//
// MessageText:
//
//  XML structure: XML file does not contain a SIIICfg xml.
//
#define TLR_E_SIII_MA_AP_XML_FILE_IS_NOT_A_SIIICFG_XML ((TLR_RESULT)0xC0724011L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STD_PARAMS_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected tag in std_params_master block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STD_PARAMS_MASTER_BLOCK ((TLR_RESULT)0xC0724012L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_STD_PARAMS_MASTER_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: Incomplete std_params_master block.
//
#define TLR_E_SIII_MA_AP_XML_STD_PARAMS_MASTER_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724013L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_STD_PARAMS_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in std_params_master block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_STD_PARAMS_MASTER_BLOCK ((TLR_RESULT)0xC0724014L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STD_PARAMS_MASTER_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match std_params_master tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STD_PARAMS_MASTER_TAG ((TLR_RESULT)0xC0724015L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_PARAMS_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in params_master block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_PARAMS_MASTER_BLOCK ((TLR_RESULT)0xC0724016L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_PARAMS_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in params_master block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_PARAMS_MASTER_BLOCK ((TLR_RESULT)0xC0724017L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_PARAMS_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in params_master block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_PARAMS_MASTER_BLOCK ((TLR_RESULT)0xC0724018L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_PARAMS_MASTER_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match params_master tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_PARAMS_MASTER_TAG ((TLR_RESULT)0xC0724019L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_PARAMS_MASTER_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: Incomplete params_master block.
//
#define TLR_E_SIII_MA_AP_XML_PARAMS_MASTER_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC072401AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SYS_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in sys_idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SYS_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC072401BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SYS_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in sys_idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SYS_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC072401CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SYS_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in sys_idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SYS_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC072401DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SYS_IDN_ENTRY_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match sys_idn_entry tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SYS_IDN_ENTRY_TAG ((TLR_RESULT)0xC072401EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_SYS_IDN_ENTRY_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: Incomplete sys_idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_SYS_IDN_ENTRY_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC072401FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SYS_GLOBAL_IDNS_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SYS_GLOBAL_IDNS_BLOCK ((TLR_RESULT)0xC0724020L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SYS_GLOBAL_IDNS_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SYS_GLOBAL_IDNS_BLOCK ((TLR_RESULT)0xC0724021L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SYS_GLOBAL_IDNS_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match sys_global_idns tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SYS_GLOBAL_IDNS_TAG ((TLR_RESULT)0xC0724022L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_SYS_GLOBAL_IDNS_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: Incomplete sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_SYS_GLOBAL_IDNS_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724023L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in master block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_MASTER_BLOCK ((TLR_RESULT)0xC0724024L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in master block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_MASTER_BLOCK ((TLR_RESULT)0xC0724025L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_MASTER_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match master tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_MASTER_TAG ((TLR_RESULT)0xC0724026L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_MASTER_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: Incomplete master block.
//
#define TLR_E_SIII_MA_AP_XML_MASTER_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724027L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_MASTER_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in master block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_MASTER_BLOCK ((TLR_RESULT)0xC0724028L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in telegram assignment block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK ((TLR_RESULT)0xC0724029L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in telegram assignment block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK ((TLR_RESULT)0xC072402AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in telegram assignment block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_TELEGRAM_ASSIGNMENT_BLOCK ((TLR_RESULT)0xC072402BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_TELEGRAM_ASSIGNMENT_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match telegram assignment tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_TELEGRAM_ASSIGNMENT_TAG ((TLR_RESULT)0xC072402CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_TELEGRAM_ASSIGNMENT_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: telegram assignment block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_TELEGRAM_ASSIGNMENT_IS_INCOMPLETE ((TLR_RESULT)0xC072402DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STD_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in std_params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_STD_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC072402EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_STD_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in std_params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_STD_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC072402FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_STD_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in std_params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_STD_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC0724030L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STD_PARAMS_SLAVE_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match std_params_slave tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_STD_PARAMS_SLAVE_TAG ((TLR_RESULT)0xC0724031L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_STD_PARAMS_SLAVE_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: std_params_slave block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_STD_PARAMS_SLAVE_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724032L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC0724033L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC0724034L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_PARAMS_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in params_slave block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_PARAMS_SLAVE_BLOCK ((TLR_RESULT)0xC0724035L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_PARAMS_SLAVE_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match params_slave tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_PARAMS_SLAVE_TAG ((TLR_RESULT)0xC0724036L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_PARAMS_SLAVE_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: params_slave block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_PARAMS_SLAVE_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724037L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_SLAVE_BLOCK ((TLR_RESULT)0xC0724038L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in slave block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_SLAVE_BLOCK ((TLR_RESULT)0xC0724039L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SLAVE_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in slave block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SLAVE_BLOCK ((TLR_RESULT)0xC072403AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SLAVE_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match slave tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_SLAVE_TAG ((TLR_RESULT)0xC072403BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_SLAVE_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: slave block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_SLAVE_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC072403CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_ENTRY_DATA_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_ENTRY_DATA_BLOCK ((TLR_RESULT)0xC072403DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_ENTRY_DATA_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_ENTRY_DATA_BLOCK ((TLR_RESULT)0xC072403EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_IDN_ENTRY_DATA_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_IDN_ENTRY_DATA_BLOCK ((TLR_RESULT)0xC072403FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_ENTRY_DATA_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match idn_entry tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_ENTRY_DATA_TAG ((TLR_RESULT)0xC0724040L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_DATA_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: idn_entry block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_DATA_IS_INCOMPLETE ((TLR_RESULT)0xC0724041L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_HAS_INVALID_ATTRIBUTE
//
// MessageText:
//
//  XML structure: idn_entry block has invalid attribute.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_HAS_INVALID_ATTRIBUTE ((TLR_RESULT)0xC0724042L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ENTRY_DATA_BLOCK_HAS_INVALID_DATA
//
// MessageText:
//
//  XML structure: idn_entry block has invalid data.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ENTRY_DATA_BLOCK_HAS_INVALID_DATA ((TLR_RESULT)0xC0724043L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ENTRY_DATA_BLOCK_CONTAINS_NON_HEX_DIGIT_CHARACTERS
//
// MessageText:
//
//  XML structure: idn_entry block contains non-hex digit characters.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ENTRY_DATA_BLOCK_CONTAINS_NON_HEX_DIGIT_CHARACTERS ((TLR_RESULT)0xC0724044L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC0724045L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC0724046L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC0724047L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_ENTRY_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match idn_entry tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_ENTRY_TAG ((TLR_RESULT)0xC0724048L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: idn_entry block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ENTRY_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724049L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SEQUENCE_OF_TAGS_IN_IDN_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected sequence of tags in idn_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SEQUENCE_OF_TAGS_IN_IDN_ENTRY_BLOCK ((TLR_RESULT)0xC072404AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in idn_config block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_IDN_CONFIG_BLOCK ((TLR_RESULT)0xC072404BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in idn_config block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_IDN_CONFIG_BLOCK ((TLR_RESULT)0xC072404CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_CONFIG_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match idn_config tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_IDN_CONFIG_TAG ((TLR_RESULT)0xC072404DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONNECTION_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in connection_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONNECTION_ENTRY_BLOCK ((TLR_RESULT)0xC072404EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONNECTION_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in connection_entry block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONNECTION_ENTRY_BLOCK ((TLR_RESULT)0xC072404FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_CONNECTION_ENTRY_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in connection_entry block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_CONNECTION_ENTRY_BLOCK ((TLR_RESULT)0xC0724050L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONNECTION_ENTRY_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match connection_entry tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONNECTION_ENTRY_TAG ((TLR_RESULT)0xC0724051L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_ENTRY_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: connection_entry block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_ENTRY_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC0724052L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONNECTIONS_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in connections block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONNECTIONS_BLOCK ((TLR_RESULT)0xC0724053L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONNECTIONS_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in connections block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONNECTIONS_BLOCK ((TLR_RESULT)0xC0724054L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONNECTIONS_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match connections tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONNECTIONS_TAG ((TLR_RESULT)0xC0724055L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected single tag in config block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SINGLE_TAG_IN_CONFIG_BLOCK ((TLR_RESULT)0xC0724056L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected opening tag in config block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_OPENING_TAG_IN_CONFIG_BLOCK ((TLR_RESULT)0xC0724057L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in config block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_CONFIG_BLOCK ((TLR_RESULT)0xC0724058L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONFIG_TAG
//
// MessageText:
//
//  XML structure: Closing tag does not match config tag.
//
#define TLR_E_SIII_MA_AP_XML_CLOSING_TAG_DOES_NOT_MATCH_CONFIG_TAG ((TLR_RESULT)0xC0724059L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONFIG_BLOCK_IS_INCOMPLETE
//
// MessageText:
//
//  XML structure: config block is incomplete.
//
#define TLR_E_SIII_MA_AP_XML_CONFIG_BLOCK_IS_INCOMPLETE ((TLR_RESULT)0xC072405AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNEXPECTED_SEQUENCE_OF_TAGS_IN_CONFIG_BLOCK
//
// MessageText:
//
//  XML structure: Unexpected sequence of tags in config block.
//
#define TLR_E_SIII_MA_AP_XML_UNEXPECTED_SEQUENCE_OF_TAGS_IN_CONFIG_BLOCK ((TLR_RESULT)0xC072405BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_DATA_LENGTH_OF_SYS_IDN_ENTRY
//
// MessageText:
//
//  XML structure: Invalid Data Length of Sys Idn Entry.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_DATA_LENGTH_OF_SYS_IDN_ENTRY ((TLR_RESULT)0xC072405CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SYS_GLOBAL_IDNS_BLOCK
//
// MessageText:
//
//  XML structure: Duplicate tag in sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_DUPLICATE_TAG_IN_SYS_GLOBAL_IDNS_BLOCK ((TLR_RESULT)0xC072405DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_UNSUPPORTED_IDN_IN_SYS_GLOBAL_IDNS_BLOCK
//
// MessageText:
//
//  XML structure: Unsupported IDN in sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_UNSUPPORTED_IDN_IN_SYS_GLOBAL_IDNS_BLOCK ((TLR_RESULT)0xC072405EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_IDN_DATA_IN_SYS_GLOBAL_IDNS_BLOCK
//
// MessageText:
//
//  XML structure: Invalid IDN data in sys_global_idns block.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_IDN_DATA_IN_SYS_GLOBAL_IDNS_BLOCK ((TLR_RESULT)0xC072405FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_TELEGRAM_NUMBER_IN_TELEGRAM_ASSIGNMENT
//
// MessageText:
//
//  XML structure: Invalid Telegram Number in Telegram Assignment.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_TELEGRAM_NUMBER_IN_TELEGRAM_ASSIGNMENT ((TLR_RESULT)0xC0724060L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_TELEGRAM_OFFSET_IN_TELEGRAM_ASSIGNMENT
//
// MessageText:
//
//  XML structure: Invalid Telegram Offset in Telegram Assignment.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_TELEGRAM_OFFSET_IN_TELEGRAM_ASSIGNMENT ((TLR_RESULT)0xC0724061L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_ACTIVE_FIELD
//
// MessageText:
//
//  XML structure: Invalid Value in Active Field.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_ACTIVE_FIELD ((TLR_RESULT)0xC0724062L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_SERCOS_ADDRESS
//
// MessageText:
//
//  XML structure: Invalid SERCOS Address in Configuration.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_SERCOS_ADDRESS ((TLR_RESULT)0xC0724063L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_HOTPLUG_FIELD
//
// MessageText:
//
//  XML structure: Invalid Value in Hot Plug Field.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_HOTPLUG_FIELD ((TLR_RESULT)0xC0724064L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_NRT_SUPPORT_FIELD
//
// MessageText:
//
//  XML structure: Invalid Value in NRT Support Field.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_VALUE_IN_NRT_SUPPORT_FIELD ((TLR_RESULT)0xC0724065L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_DATA_LENGTH_INVALID
//
// MessageText:
//
//  XML structure: IDN Data Length invalid.
//
#define TLR_E_SIII_MA_AP_XML_IDN_DATA_LENGTH_INVALID ((TLR_RESULT)0xC0724066L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_PHASE_TRANSITION_INVALID
//
// MessageText:
//
//  XML structure: IDN Phase Transition invalid.
//
#define TLR_E_SIII_MA_AP_XML_IDN_PHASE_TRANSITION_INVALID ((TLR_RESULT)0xC0724067L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_IDN_ELEMENT_INVALID
//
// MessageText:
//
//  XML structure: IDN Element invalid.
//
#define TLR_E_SIII_MA_AP_XML_IDN_ELEMENT_INVALID ((TLR_RESULT)0xC0724068L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_NUMBER_INVALID
//
// MessageText:
//
//  XML structure: Connection Number invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_NUMBER_INVALID ((TLR_RESULT)0xC0724069L)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_OFFSET_INVALID
//
// MessageText:
//
//  XML structure: Connection Telegram Offset invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_OFFSET_INVALID ((TLR_RESULT)0xC072406AL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_NUMBER_INVALID
//
// MessageText:
//
//  XML structure: Connection Telegram Number invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_NUMBER_INVALID ((TLR_RESULT)0xC072406BL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_TYPE_INVALID
//
// MessageText:
//
//  XML structure: Connection Telegram Type invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_TELEGRAM_TYPE_INVALID ((TLR_RESULT)0xC072406CL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_LENGTH_INVALID
//
// MessageText:
//
//  XML structure: Connection Length invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_LENGTH_INVALID ((TLR_RESULT)0xC072406DL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_RTDATA_DPM_OFFSET_INVALID
//
// MessageText:
//
//  XML structure: Connection RtData DPM Offset invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_RTDATA_DPM_OFFSET_INVALID ((TLR_RESULT)0xC072406EL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_CONNECTION_CCTRL_DPM_OFFSET_INVALID
//
// MessageText:
//
//  XML structure: Connection CCtrl DPM Offset invalid.
//
#define TLR_E_SIII_MA_AP_XML_CONNECTION_CCTRL_DPM_OFFSET_INVALID ((TLR_RESULT)0xC072406FL)

//
// MessageId: TLR_E_SIII_MA_AP_XML_INVALID_SEQUENCE_OF_TAGS_IN_SIIICFG_BLOCK
//
// MessageText:
//
//  XML structure: Invalid sequence of tags in SIIICfg Block.
//
#define TLR_E_SIII_MA_AP_XML_INVALID_SEQUENCE_OF_TAGS_IN_SIIICFG_BLOCK ((TLR_RESULT)0xC0724070L)

//
// MessageId: TLR_E_SIII_MA_AP_AT_LEAST_ONE_SLAVE_MISSING
//
// MessageText:
//
//  At least one slave is missing.
//
#define TLR_E_SIII_MA_AP_AT_LEAST_ONE_SLAVE_MISSING ((TLR_RESULT)0xC0724071L)

//
// MessageId: TLR_E_SIII_MA_AP_BUS_IS_SPLIT_IN_TWO_LINES
//
// MessageText:
//
//  Bus is split in two lines.
//
#define TLR_E_SIII_MA_AP_BUS_IS_SPLIT_IN_TWO_LINES ((TLR_RESULT)0xC0724072L)

//
// MessageId: TLR_E_SIII_MA_AP_NO_SLAVES_CONNECTED
//
// MessageText:
//
//  No slaves connected.
//
#define TLR_E_SIII_MA_AP_NO_SLAVES_CONNECTED ((TLR_RESULT)0xC0724073L)

//
// MessageId: TLR_E_SIII_MA_AP_UNCONFIGURED_SLAVE_DETECTED
//
// MessageText:
//
//  At least one unconfigured slave detected.
//
#define TLR_E_SIII_MA_AP_UNCONFIGURED_SLAVE_DETECTED ((TLR_RESULT)0xC0724074L)

//
// MessageId: TLR_E_SIII_MA_AP_DUPLICATE_SERCOS_ADDRESS
//
// MessageText:
//
//  Duplicate SERCOS address detected.
//
#define TLR_E_SIII_MA_AP_DUPLICATE_SERCOS_ADDRESS ((TLR_RESULT)0xC0724075L)

//
// MessageId: TLR_E_SIII_MA_AP_INVALID_SERCOS_ADDRESS_DETECTED
//
// MessageText:
//
//  Invalid SERCOS address detected.
//
#define TLR_E_SIII_MA_AP_INVALID_SERCOS_ADDRESS_DETECTED ((TLR_RESULT)0xC0724076L)

//
// MessageId: TLR_E_SIII_MA_AP_SVCH_ERROR_ON_SLAVE
//
// MessageText:
//
//  Service channel access on one slave ended with error.
//
#define TLR_E_SIII_MA_AP_SVCH_ERROR_ON_SLAVE ((TLR_RESULT)0xC0724077L)

//
// MessageId: TLR_E_SIII_MA_AP_INVALID_CP0_BUS_STATUS
//
// MessageText:
//
//  Invalid CP0 Bus Status.
//
#define TLR_E_SIII_MA_AP_INVALID_CP0_BUS_STATUS ((TLR_RESULT)0xC0724078L)

//
// MessageId: TLR_E_SIII_MA_AP_DEVICE_IDENT_MISMATCH
//
// MessageText:
//
//  Device Ident Mismatch.
//
#define TLR_E_SIII_MA_AP_DEVICE_IDENT_MISMATCH ((TLR_RESULT)0xC0724079L)

//
// MessageId: TLR_E_SIII_MA_AP_FEATURES_NOT_ACKNOWLEDGED
//
// MessageText:
//
//  Advertised features in CP0 are not acknowledged.
//
#define TLR_E_SIII_MA_AP_FEATURES_NOT_ACKNOWLEDGED ((TLR_RESULT)0xC072407AL)

//
// MessageId: TLR_E_SIII_MA_AP_NO_MATCHING_MANDATORY_SLAVE_LIST
//
// MessageText:
//
//  No matching mandatory slave list.
//
#define TLR_E_SIII_MA_AP_NO_MATCHING_MANDATORY_SLAVE_LIST ((TLR_RESULT)0xC072407BL)

//
// MessageId: TLR_E_SIII_MA_AP_FIRMWARE_HAS_CRASHED
//
// MessageText:
//
//  Firmware has crashed.
//
#define TLR_E_SIII_MA_AP_FIRMWARE_HAS_CRASHED ((TLR_RESULT)0xC072407CL)

//
// MessageId: TLR_E_SIII_MA_AP_PACKET_CMD_NOT_ALLOWED
//
// MessageText:
//
//  Packet command not allowed.
//
#define TLR_E_SIII_MA_AP_PACKET_CMD_NOT_ALLOWED ((TLR_RESULT)0xC072407DL)




#endif  //__SERCOSIII_MA_AP_ERROR_H

